 ; Exget - retrieve extended data from an entity.
 ; Copyright 1994 by Rocket Software
 ; Application names are listed at the end of the standard entget call, wild
 ; cards (such as *) or specific program names are allowed.

 ; Vdat - get the height and width of the current viewport.
 (DEFUN C:VDAT ()
  (setq vwdata (screw2))
  (setq maxx (nth 0 vwdata))
  (setq minx (nth 1 vwdata))
  (setq maxy (nth 2 vwdata))
  (setq miny (nth 3 vwdata))
  (setq wid (- maxx minx))
  (setq height (- maxy miny))
  (print wid)
  (print height)
 (princ))

 ; Ŀ
 ;   Subroutine Screw2 - find the area currently onscreen.                 
 ;   Returns the maximum and minimum x and y coordinates as a list.        
 ;   See also Screw, which returns the centre 75% of the screen.           
 ; 
 (DEFUN SCREW2 (/ scrnsz scrat vhhght ctr vhwid maxx minx maxy miny)
 ; Get the screen size variables.
  (setq scrnsz (getvar "screensize"))         ; view height & width (pixels)
  (setq scrat (/ (car scrnsz) (cadr scrnsz))) ; view width/height ratio
  (setq vhhght (/ (getvar "viewsize") 2.0))   ; view half height in dwg units
  (setq ctr (getvar "viewctr"))               ; centre point of screen
  (setq vhwid (* vhhght scrat))               ; view halfwidth
 ; Find the minimum and maximum x and y coordinates.
  (setq maxx (+ (car ctr) vhwid))
  (setq minx (- (car ctr) vhwid))
  (setq maxy (+ (cadr ctr) vhhght))
  (setq miny (- (cadr ctr) vhhght))
 ; Find the coordinates of the screen corners
  (setq aa (list minx miny))
  (setq bb (list minx maxy))
  (setq cc (list maxx maxy))
  (setq dd (list maxx miny))
  (grdraw aa bb 1 1)
  (grdraw bb cc 1 1)
  (grdraw cc dd 1 1)
  (grdraw dd aa 1 1)
  (grdraw aa cc 1 1)
  (grdraw dd bb 1 1)
 (list maxx minx maxy miny))
 ; Ŀ
 ;   Screw2 end.                                                           
 ; 

 (DEFUN C:EXFIL (/ aa bb)
  (setq aa (entget (setq enam (car (entsel)))))
  (print aa)
  (princ)
  (setq bb (entget enam (list "*")))
  (if (setq exdat (assoc -3 bb))
      (print exdat)
      (write-line "\nNo extended data found."))
  (setq fn (open "exdat.doc" "w"))
  (print aa fn)
  (if (setq exdat (assoc -3 bb))
      (print exdat fn)
      (write-line "\nNo extended data found." fn))
  (close fn)
 (princ))

 (DEFUN C:EXGET (/ aa bb)
  (setq aa (entget (setq enam (car (entsel)))))
  (print aa)
  (princ)
  (setq bb (entget enam (list "*")))
  (if (setq exdat (assoc -3 bb))
      (print exdat)
      (write-line "\nNo extended data found."))
 (princ))